local P2xpos;
local P2ypos;
local P1, P2, jud1, jud2, com1, com2, P1Score, P2Score;

local songName = GAMESTATE:GetCurrentSong():GetSongDir() -- Looks for Song

local function handler_mod_internal(str, pn) -- Aplies Players options to not be disabled-
    local ps = GAMESTATE:GetPlayerState(pn)
    local pmods = ps:GetPlayerOptionsString('ModsLevel_Song')
    ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
    -- GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function handler_mod(str) -- Looks for many players are on the screen
    for i = 1, 2 do handler_mod_internal(str, 'PlayerNumber_P' .. i) end
end

local function handler_init() -- Useful for command shorcuts
    checked = false;
    if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P1Score') then
        P1Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild(
                      'P1Score')
    end
    if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P2Score') then
        P2Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild(
                      'P2Score')
    end

    -- lua course :D	/ timed mod management	
    curmod = 1;
    -- {beat,'mod'},
    mods = {
		{70, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, *5 500 Beat'},
		{70.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {71, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, No Beat'},
		{71.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},

        {78, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, *5 500 Beat'},
		{78.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {79, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, No Beat'},
		{79.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},

        {86, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, *5 500 Beat'},
		{86.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {87, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, No Beat'},
		{87.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},

        {132, '*1 100% Beat'},
        {147, '*1 no Beat'},

        -- Bouncy Sections
		{180, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, *5 500 Beat'},
		{180.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {181, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, No Beat'},
        {181.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},
		{182, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, *5 500 Beat'},
		{182.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {183, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, No Beat'},
        {183.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},

        {184, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {184.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {185, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {185.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},
        {186, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {186.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {187, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {187.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},

        {188, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {188.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {189, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {189.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},
        {190, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {190.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {191, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {191.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},
        {192, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {192.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {193, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {193.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},
        {194, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {194.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {195, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {195.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},

        {196, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {196.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {197, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {197.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},
        {198, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {198.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {199, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {199.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},

        {200, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 10 Split, No Bumpy, *5 500 Beat'},
        {200.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {201, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 10 Split, No Bumpy, *5 500 Beat'},
        {201.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},
        {202, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 10 Split, No Bumpy, *5 500 Beat'},
        {202.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {203, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 10 Split, No Bumpy, *5 500 Beat'},
        {203.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},

        {204, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {204.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {205, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {205.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},
        {206, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {206.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {207, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {207.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},
        {208, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {208.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {209, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {209.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, *1 No Beat'},
        {210, '*2 -10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 -10 Split, No Bumpy, *5 500 Beat'},
        {211.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},

		{212, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, *5 500 Beat'},
		{212.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
		{213, '*2 10 Reverse, *2 100 Tipsy, *2 20 Invert, *2 20 Dizzy, *3 10 Split, *2 100 Bumpy, *5 500 Beat'},
		{213.5, 'No Reverse, No Split, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},

        --{216, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 -10 Cross, No Bumpy, *5 500 Beat'}, -- UD
        {216, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 -10 Alternate, No Bumpy, *5 500 Beat'}, -- UD
        {216.5, 'No Reverse, No Alternate, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {217, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 -10  Alternate, No Bumpy, *5 500 Beat'},
        {217.5, 'No Reverse, No  Alternate, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},

        {220, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 -10 Cross, No Bumpy, *5 100 Beat'}, -- UD
        {220.5, 'No Reverse, No Cross, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {221, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 20 Cross, No Bumpy, *5 100 Beat'}, -- UD
        {221.5, 'No Reverse, No Cross, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {222, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 -10 Cross, No Bumpy, *5 500 Beat'}, -- UD
        {222.5, 'No Reverse, No Cross, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {223, '*2 -10 Reverse, *2 100 Tipsy, *2 -20 Invert, *2 -20 Dizzy, *3 20 Cross, No Bumpy, *5 50 Beat'}, -- UD
        {223.5, 'No Reverse, No Cross, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},

        {224, '*1 -10 Reverse, *1 -20 Invert, *2 -30 Cross, No Bumpy, *5 50% Beat'}, -- UD
        {225, 'No Reverse, No Cross, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        {226, '*1 -10 Reverse, *1 -20 Invert, *2 30 Cross, No Bumpy, *5 50% Beat'}, -- UD
        {227, 'No Reverse, No Cross, No Tipsy, No Invert, No Dizzy, No Bumpy, No Beat'},
        }

    curmessage = 1;
    -- {beat,message,ignoreIfAhead}
    messages = {
        {120, "Slickback"}, 
        {145, "HideSlick"},
        {179.75, "Caleb1"}, 
        {187.25, "Caleb2"},
        {195.25, "Caleb3"}, 
        {203.75, "Caleb4"},
        {226, "Slickback2"}, 
        {223.5, "Slickback3"}, 
        {248, "HideAll"}, 



        -- Lua messages go here, you can add them by using "MessageCommand= function(self)" after you inserted the name.

    }

end

local function handler_update() -- Updates the command to look for the players at the start of the song.

    if GAMESTATE:GetSongBeat() >= 0.1 and not checked then

        if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
            P1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
        end

        if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
            P2 = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
        end
        -- PE = SCREENMAN:GetTopScreen():GetChild('')

        screen = SCREENMAN:GetTopScreen()
        checked = true;

    end

    local beat = GAMESTATE:GetSongBeat()

    -- Collect all the mods that will be applied in this frame into one string.
    -- Mod tweening doesn't work correctly if the mods are in seperate commands.
    local mods_this_frame = {}
    local function add_mod(mod_str)
        mods_this_frame[#mods_this_frame + 1] = mod_str
    end
    local function execute_mods()
        if #mods_this_frame <= 0 then return end
        local total_mod_str = ""
        for i, ms in ipairs(mods_this_frame) do
            if #total_mod_str > 0 then
                total_mod_str = total_mod_str .. ", "
            end
            total_mod_str = total_mod_str .. ms
        end
        handler_mod(total_mod_str)
    end

    while curmod <= #mods and GAMESTATE:GetSongBeat() >= mods[curmod][1] do
        add_mod(mods[curmod][2])
        curmod = curmod + 1
    end

    execute_mods()

    -- SCREAMING GUMBALL
    while curmessage <= #messages and GAMESTATE:GetSongBeat() >=
        messages[curmessage][1] do
        if messages[curmessage][3] and GAMESTATE:GetSongBeat() >=
            messages[curmessage][1] + 5 then
            curmessage = curmessage + 1;
        else
            MESSAGEMAN:Broadcast(messages[curmessage][2])
            curmessage = curmessage + 1;
        end
    end
end

return Def.ActorFrame {

    OnCommand = function(self)
        handler_init()
        self:SetUpdateFunction(handler_update)
        local screen = SCREENMAN:GetTopScreen()
    end,
    Def.Quad {
        Name = "I may be sleeping, but I preserve the world.",
        InitCommand = cmd(visible, false),
        OnCommand = cmd(sleep, 1000)
    },
    LoadActor("../Slickback.jpg") .. {
        OnCommand = function(self)
            self:FullScreen()
        end,
    },
    Def.Quad {
        OnCommand = function(self)
            self:FullScreen():diffuse(Color.Black):diffusealpha(0)
        end,
        SlickbackMessageCommand = function(self)
            self:diffusealpha(1):queuecommand("Hide")
        end,
        HideCommand = function(self)
            self:sleep(12):linear(1):diffusealpha(0)
        end,
        Slickback3MessageCommand = function(self)
            self:sleep(2):accelerate(2):diffusealpha(1)
        end,
        HideAllMessageCommand=function(self)
            self:linear(1):diffusealpha(0)
        end
    },
    LoadActor("BG-Vid.mp4") .. {
        OnCommand = function(self)
            self:Center():zoom(0.5):diffusealpha(0):loop(false):rate(0)
        end,
        SlickbackMessageCommand = function(self)
            self:rate(1):loop(true):diffusealpha(1)
        end,
        HideSlickMessageCommand = function(self)
            self:linear(0.5):diffusealpha(0):loop(false)
        end,
        Slickback3MessageCommand = function(self)
            self:rate(1):loop(true):sleep(2):accelerate(1):diffusealpha(1)
        end,
        HideAllMessageCommand=function(self)
            self:linear(1):diffusealpha(0)
        end
    },

    LoadActor("../ChokePt1.mp4") .. {
        OnCommand=function(self)
            self:Center():zoom(0.75):diffusealpha(0):loop(false):rate(0)
        end,
        Caleb1MessageCommand = function(self)
            self:loop(true):diffusealpha(1):rate(1.2)
        end,
        Caleb3MessageCommand= function(self)
            self:loop(true):diffusealpha(1):rate(1.2)
        end,
        Caleb4MessageCommand = function(self)
            self:linear(0.01):diffusealpha(0):loop(false)
        end,
        Slickback2MessageCommand= function(self)
            self:linear(1):diffusealpha(0):loop(false):rate(0):visible(false)
        end,
        HideAllMessageCommand=function(self)
            self:linear(1):diffusealpha(0)
        end
    },
    LoadActor("../ChokePt2.mp4") .. {
        OnCommand=function(self)
            self:Center():zoom(0.75):diffusealpha(0):rate(0):loop(false)
        end,
        Caleb2MessageCommand = function(self)
            self:diffusealpha(1):rate(1):loop(true)
        end,

        Caleb3MessageCommand = function(self)
            self:linear(0.01):diffusealpha(0):loop(false):rate(0)
        end,
        Slickback2MessageCommand= function(self)
            self:linear(1):diffusealpha(0):loop(false):rate(0):visible(false)
        end
    },
    LoadActor("../ChokePt4.mp4") .. {
        OnCommand=function(self)
            self:Center():zoom(0.75):diffusealpha(0):rate(0):loop(false)
        end,
        Caleb4MessageCommand= function(self)
            self:loop(true):diffusealpha(1):rate(1)
        end,
        Caleb5MessageCommand = function(self)
            self:linear(0.01):diffusealpha(0):loop(false):rate(0)
        end,
        Slickback2MessageCommand= function(self)
            self:linear(1):diffusealpha(0):loop(false):rate(0):visible(false)
        end
    },
  

}
